import { Router } from "express";
import {
  listPlaybooks,
  getPlaybookDetail,
} from "../../../../controllers/api/admin/playbooks/playbooks.controller.js";
import {
  createPlaybook,
  updatePlaybook,
  createPlaybookStep,
  updatePlaybookStep,
  deletePlaybookStep,
} from "../../../../controllers/api/admin/playbooks/playbooks.admin.controller.js";
const r = Router();

r.get("/playbooks", listPlaybooks);
r.get("/playbooks/:playbookRef", getPlaybookDetail);

// admin CRUD
r.post("/playbooks", createPlaybook);
r.patch("/playbooks/:playbookRef", updatePlaybook);

r.post("/playbooks/:playbookRef/steps", createPlaybookStep);
r.patch(
  "/playbooks/:playbookRef/steps/:stepId([0-9a-fA-F-]{36})",
  updatePlaybookStep
);
r.delete(
  "/playbooks/:playbookRef/steps/:stepId([0-9a-fA-F-]{36})",
  deletePlaybookStep
);

export default r;
