import { Router } from "express";
import {
  listMeetings,
  createMeeting,
  getMeetingDetail,
  updateMeeting,
  addAgendaItem,
  patchAgendaItem,
  archiveAgendaItem,
  archiveMeeting,
  unarchiveAgendaItem, // 👈 ÚJ
  unarchiveMeeting, // 👈 ÚJ (opcionális, de ajánlott)
} from "../../../../controllers/api/admin/meetings/meetings.controller.js";
import { createActionItemFromAgendaItem } from "../../../../controllers/api/admin/meetings/meetings.action-items.controller.js";

const r = Router();

r.get("/meetings", listMeetings);
r.post("/meetings", createMeeting);

r.get("/meetings/:meetingRef", getMeetingDetail);
r.patch("/meetings/:meetingRef", updateMeeting);

// ✅ FE-kompatibilis meeting archive/unarchive
r.post("/meetings/:meetingRef/archive", archiveMeeting);
r.post("/meetings/:meetingRef/unarchive", unarchiveMeeting);

// ✅ régi kompatibilitás
r.delete("/meetings/:meetingRef", archiveMeeting);

r.post("/meetings/:meetingRef/agenda-items", addAgendaItem);

r.patch(
  "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})",
  patchAgendaItem
);

// ✅ FE-kompatibilis agenda archive/unarchive
r.post(
  "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})/archive",
  archiveAgendaItem
);
r.post(
  "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})/unarchive",
  unarchiveAgendaItem
);

// ✅ régi kompatibilitás (delete = archive)
r.delete(
  "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})",
  archiveAgendaItem
);

r.post("/meetings/:meetingRef/action-items", createActionItemFromAgendaItem);

export default r;

// import { Router } from "express";
// import {
//   listMeetings,
//   createMeeting,
//   getMeetingDetail,
//   updateMeeting,
//   addAgendaItem,
//   patchAgendaItem,
//   archiveAgendaItem,
//   archiveMeeting,
//   unarchiveAgendaItem,unarchiveMeeting
// } from "../../../../controllers/api/admin/meetings/meetings.controller.js";
// import { createActionItemFromAgendaItem } from "../../../../controllers/api/admin/meetings/meetings.action-items.controller.js";

// const r = Router();

// r.get("/meetings", listMeetings);
// r.post("/meetings", createMeeting);

// r.get("/meetings/:meetingRef", getMeetingDetail);
// r.patch("/meetings/:meetingRef", updateMeeting);
// // oldy
// r.delete("/meetings/:meetingRef", archiveMeeting);
// // new
// r.post("/meetings/:meetingRef/archive", archiveMeeting);
// r.post("/meetings/:meetingRef/unarchive", unarchiveMeeting);

// r.post(
//   "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})/unarchive",
//   unarchiveAgendaItem
// );

// r.post("/meetings/:meetingRef/agenda-items", addAgendaItem);

// r.patch(
//   "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})",
//   patchAgendaItem
// );

// r.delete(
//   "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})",
//   archiveAgendaItem
// );
// r.post(
//   "/meetings/:meetingRef/agenda-items/:agendaItemId([0-9a-fA-F-]{36})/archive",
//   archiveAgendaItem
// );

// r.post("/meetings/:meetingRef/action-items", createActionItemFromAgendaItem);

// export default r;
