import { Router } from "express";
import {
  applyPlaybookToCase,
  getCasePlaybookChecklist,
  patchCasePlaybookChecklistStep,
  //   setCasePlaybookStepState,
} from "../../../../controllers/api/admin/cases/cases.playbook.controller.js";

const r = Router();

// POST /api/app/cases/:caseRef/apply-playbook
r.post("/cases/:caseRef/apply-playbook", applyPlaybookToCase);

// NEW: GET checklist for a case (playbook steps + done state)
r.get("/cases/:caseRef/playbook-checklist", getCasePlaybookChecklist);
// r.put(
//   "/cases/:caseRef/playbook-checklist/:stepRef([0-9a-fA-F-]{36})",
//   setCasePlaybookStepState
// );

// NEW: PATCH single step state (done/undone + notes)
r.patch(
  "/cases/:caseRef/playbook-checklist/:stepRef",
  patchCasePlaybookChecklistStep
);

export default r;
